if [ "$AWS_PROFILE" == "" ]; then AWS_PROFILE="default"; fi
echo "JMA Events - New Site"
echo
read -p "Enter Short Name (no spaces): " name
read -p "Enter Blog Title: " title
export name title
echo "Cloning Site ${name}"
mkdir -p ./sites/${name}/copilot
cp -r template ./sites/${name}/copilot/${name}-svc
mv ./sites/${name}/copilot/${name}-svc/Dockerfile ./sites/${name}/
mv ./sites/${name}/copilot/${name}-svc/startup.sh ./sites/${name}/
echo "Generating Manifest for ${name}"
./template/mo ./sites/${name}/copilot/${name}-svc/manifest.yml.mo > ./sites/${name}/copilot/${name}-svc/manifest.yml
echo "Setting up site images for ${name}"
cd ./sites/${name}

copilot app init --domain eventhome.page ${name}-app 
copilot env init -n wordpress -a ${name}-app --profile $AWS_PROFILE  --default-config
copilot svc init -a ${name}-app -n ${name}-svc
copilot svc deploy --name ${name}-svc -a ${name}-app -e wordpress

