# The manifest for the "fe" service.
# Read the full specification for the "Load Balanced Web Service" type at:
#  https://aws.github.io/copilot-cli/docs/manifest/lb-web-service/

# Your service name will be used in naming your resources like log groups, ECS services, etc.
name: {{name}}-svc
type: Load Balanced Web Service

# Distribute traffic to your service.
http:
  # Requests to this path will be forwarded to your service.
  # To match all requests you can use the "/" path.
  path: '/'
  # You can specify a custom health check path. The default is "/".
  # healthcheck: '/'
  healthcheck:
    path: /
    success_codes: '200-399'
    interval: 60s
    timeout: 8s
    healthy_threshold: 3
    unhealthy_threshold: 5
  stickiness: true
  alias: {{name}}.eventhome.page
  
# Configuration for your containers and service.
image:
  # Docker build arguments. For additional overrides: https://aws.github.io/copilot-cli/docs/manifest/lb-web-service/#image-build
  build: Dockerfile
  # Port exposed through your container to route traffic to it.
  port: 8080

cpu: 1024       # Number of CPU units for the task.
memory: 2048    # Amount of memory in MiB used by the task.
platform: linux/x86_64  # See https://aws.github.io/copilot-cli/docs/manifest/lb-web-service/#platform

count:         # Number of tasks that should be running in your service.
  range:
    min: 1
    max: 50
    spot_from: 30
  cpu_percentage: 60

exec: true     # Enable running commands in your container.

# Optional fields for more advanced use-cases.
#
variables:                    # Pass environment variables as key value pairs.
  LOG_LEVEL: info
  WORDPRESS_USERNAME: joeladmin
  WORDPRESS_PASSWORD: BlueBillyGoat8i3
  WORDPRESS_EMAIL: joel@jma.events
  WORDPRESS_BLOG_NAME: "{{title}}"
  OVERRIDE_WP_HOME: "{OVERRIDE_WP_HOME}"
  
#secrets:                      # Pass secrets from AWS Systems Manager (SSM) Parameter Store.
#  GITHUB_TOKEN: GITHUB_TOKEN  # The key is the name of the environment variable, the value is the name of the SSM parameter.

# You can override any of the values defined above by environment.
#environments:
#  test:
#    count: 2               # Number of tasks to run for the "test" environment.

storage:
  volumes:
    wp-content:
      path: /bitnami/wordpress
      read_only: false
      efs: true
      
