<?php

class Oauth_AdminClientsController extends Am_Mvc_Controller_Grid
{
    use \Am_Oauth_Traits_GetModule;
    function checkAdminPermissions(\Admin $admin)
    {
        return $admin->hasPermission(Bootstrap_Oauth::ADMIN_PERMISSION_CLIENTS);
    }
    
    public
        function createGrid()
    {
        $ds = new \Am_Query($this->getDi()->oauthClientTable);
        $grid = new \Am_Grid_Editable('_oauth_clients', ___('Manage Applications'), $ds, $this->getRequest(), $this->view);
        $grid->addField('name', ___('App Name'));
        $grid->addField('client_id', ___('Client ID'));
        $grid->addField('description', ___('Description'));
        $grid->addField('grant_type', ___('Grant Types'))->setRenderFunction(function($record){
            return $this->renderTd(implode(", ", $record->getGrantType()));
        });
        $grid->addField(new Am_Grid_Field_Expandable('client_secret', ___('App Secret')));
        $grid->setForm([$this, 'createForm']);
        $grid->addCallback(Am_Grid_Editable::CB_VALUES_FROM_FORM, function(&$values, $record) use ($grid){
            if(empty($record->client_id))
            {
                do{
                    $record->client_id = bin2hex(random_bytes(32));
                }while($this->getDi()->oauthClientTable->findFirstBy(['client_id'=>$values['client_id']]));
                
                $record->client_secret = bin2hex(random_bytes(32));
            }
            $record->grant_type = json_encode(array_filter(array_values($values['grant_type'])));
            unset($values['grant_type']);

            $record->scope = json_encode($values['scope']);
            unset($values['scope']);
            
        });
        
        $grid->addCallback(Am_Grid_Editable::CB_TR_ATTRIBS, function(& $ret, $record)
        {
            if ($record->is_disabled) {
                $ret['class'] = isset($ret['class']) ? $ret['class'] . ' disabled' : 'disabled';
            }
        });
        
        $grid->addCallback(Am_Grid_Editable::CB_VALUES_TO_FORM, function(&$values, $record) use ($grid){
            $values['grant_type'] = !empty($record->grant_type) ? array_combine($k = json_decode($record->grant_type, true), $k) : [];
            $values['scope'] = !empty($record->scope) ? json_decode($record->scope, true) : [];
        });
        return $grid;
    }
    
    
    function createForm()
    {
        $form = new \Am_Form_Admin('oauth-client');
        $form->addText('name',['class' => 'am-el-wide'])->setLabel(___("Application Name\n"
            . "Visible name that clients will see"))
            ->addRule('required');
        $form->addTextarea('description', ['class'=>'am-el-wide'])->setLabel(___("Description\n"
            . "for internal use"));
        
        foreach($this->getModule()->getEnabledGrantTypesOptions() as $grant){
            $fs = $form->addFieldset('grant-'.$grant)->setLabel(___("Grant Type: %s", $grant));
            $fs->addAdvCheckbox("grant_type[{$grant}]", ['value' => $grant])->setLabel(
                ___("Enable Grant: %s", $grant)."\n".$this->getModule()->getAuthorizationServer()->getGrantTypeById($grant)->getDescription()
                );
            ;
            $options = $this->getModule()->getScopeRepository()->getScopeOptions($grant);
            if(!empty($options))
                $fs->addMagicSelect("scope[{$grant}]", ['class' => 'am-combobox'])
                    ->setLabel(___("Permissions\n"
                        . "Do not give more permissions then required"))
                    ->loadOptions($options);
            
        }
        
        
        $form->addFieldset('')->setLabel(___('Optional'));
        $form->addTextarea('redirect_uri', ['class'=>'am-el-wide'])
            ->setLabel(___("Redirect URI\n"
                . "In case of authorization_code grant flow, authorization code will be sent to that URI\n"
                . "Specify one url per row"));
        
        $form->addAdvCheckbox('require_secret')
            ->setLabel(___("Always Require Client Secret\n"
                . "By default client secret is required for client_credentials,\n"
                . "or authorization_code grant types\n"
                . "Setting allow to require client_secret even if it optional for grant type\n"));
        
        $form->addAdvCheckbox('is_disabled')->setLabel('Disable Client');
        
        $form->addEpilog(sprintf("<div class='info'><pre>%s</pre></div>", $this->getReadme()));
        
        return $form;
    }
    
    function getReadme(){
        $url = $this->getDi()->surl('oauth/token');
        return <<<CUT
CUT;
    }

}
