<?php

use League\OAuth2\Server\Exception\OAuthServerException;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Zend\Diactoros\Stream;
use League\OAuth2\Server\RequestTypes\AuthorizationRequest;

class Oauth_AuthorizeController extends Am_Mvc_Oauth_Controller
{
    
    use Am_Oauth_Traits_GetModule;
    
    function preDispatch()
    {
        $this->getDi()->auth->requireLogin($this->getRequest()->assembleUrl());
    }
    
    /**
     * @return Am_Session_Ns
     */
    public
    function getSession()
    {
        return $this->getDi()->session->ns('oath-authorize');
    }
    
    function indexAction()
    {
        
        $server = $this->getModule()->getAuthorizationServer();
        
        try {
            
            $authRequest = $server->validateAuthorizationRequest($this->getOauthRequest());
            
            
            $authRequest->setUser($oauthUser = $this->getDi()->oauthUserTable->load($this->getDi()->auth->getUserId()));
            $this->getSession()->authRequest = $authRequest;
            
            $userConsent = $oauthUser->getOauthConsent($authRequest->getClient()->oauth_client_id);
            if (($userConsent !== false) && !array_diff(array_map(function ($scope)
                {
                    return $scope->getIdentifier();
                }, $authRequest->getScopes()), $userConsent)) {
                $form = $this->getAuthorizationForm($authRequest);
                $form->__toString(); // Create CSRF Key
                $value = $form->getValue() + ['allow' => ___('Allow')];
                $form->setDataSources([new HTML_QuickForm2_DataSource_Session($value)]);
                // User already allowed access;
                return $this->redirectAction($form);
            }
            
            $this->view->content = $this->getAuthorizationForm($authRequest);
            $this->view->title = ___('Your permission is required');
            $this->view->display('member/layout.phtml');
        } catch (OAuthServerException $exception) {
            
            if ($exception->getErrorType() == 'invalid_client') {
                $this->getDi()->logger->info("Client authentication failed, request={request}", [
                    'exception' => $exception,
                    'request' => $this->getOauthRequest()
                ]);
                throw new Am_Exception_InputError($exception->getMessage());
            }
            // All instances of OAuthServerException can be formatted into a HTTP response
            return $exception->generateHttpResponse($this->getOauthResponse());
        } catch (\Exception $exception) {
            
            // Unknown exception
            $body = new Stream(fopen('php://temp', 'r+'));
            $body->write($exception->getMessage());
            return $this->getOauthResponse()->withStatus(500)->withBody($body);
        }
    }
    
    function redirectAction(Am_Form $form = null)
    {
        $server = $this->getModule()->getAuthorizationServer();
        
        $authRequest = $this->getSession()->authRequest;
        
        $this->getSession()->authRequest = null;
        
        if (empty($form)) {
            $form = $this->getAuthorizationForm($authRequest);
        }
        if ($form->isSubmitted() && $form->validate()) {
            $value = $form->getValue();
            
            $authRequest->setAuthorizationApproved(!empty($value['allow']) ? true : false);
            
            $_ = [];
            foreach ($authRequest->getScopes() as $scope) {
                if ($authRequest->getClient()->isAllowedScope($scope, Bootstrap_Oauth::GRANT_AUTHORIZATION_CODE)) {
                    $_[] = $scope;
                }
            }
            $authRequest->getUser()->setOauthConsent($authRequest->getClient()->oauth_client_id, $_);
            
            try {
                return $server->completeAuthorizationRequest($authRequest, $this->getOauthResponse());
            } catch (OAuthServerException $ex) {
                return $ex->generateHttpResponse($this->getOauthResponse());
            }
        } else {
            throw new Am_Exception_Security('Access denied!');
        }
    }
    
    /**
     * @return Am_Form
     */
    function getAuthorizationForm(AuthorizationRequest $request)
    {
        $form = new Am_Form('_authorize');
        $form->setAction($this->url('oauth/authorize/redirect'));
        $form->addElement(new Am_Form_Element_Csrf());
        $client = $request->getClient();
        $req = ___("Application '%s' require your permission to perform following actions on your behalf\n",
            "<b>" . $client->getName() . "</b>");
        
        $form->addHtml('', ['class' => 'am-no-label'])->
        setHTML(___("Application '%s' require your permission to perform following actions on your behalf\n"
            . "You should allow access only if you trust this application", "<b>" . $client->getName() . "</b>"));
        
        $scopesText = "<ul>";
        foreach ($request->getScopes() as $scope) {
            if ($request->getClient()->isAllowedScope($scope, Bootstrap_Oauth::GRANT_AUTHORIZATION_CODE)) {
                $scopesText .= "<li>" . ($scope->getDescription() ?: $scope->getIdentifier()) . "</li>";
            }
        }
        $scopesText .= "</ul>";
        $form->addHTML()->setHtml($scopesText)->setLabel(___('Information/permissions requested'));
        $gr = $form->addGroup('');
        $gr->setSeparator(' ');
        $gr->addSubmit('allow', ['value' => ___('Allow')]);
        $gr->addSubmit('decline', ['value' => ___('Decline')]);
        return $form;
    }
}