<?php

class Oauth_ConfirmEmailController  extends Am_Mvc_Controller
{
    use Am_Oauth_Traits_GetModule;
    function indexAction()
    {
        $em = $this->getFiltered('em');
        if(strpos($em, '-')!==false)
        {
            list($user_id, $code) = explode('-', $em);
            $user_id = $this->getDi()->security->reveal($user_id);
            if($user_id)
            {
                $user = $this->getDi()->userTable->load($user_id);
                if($this->getModule()->confirmEmailAddress($user, $code))
                {
                    $this->view->title = ___('Email Address Confirmed');
                    $this->view->content = ___('Your Email Address was confirmed!  %sLogin%s to continue.',
                        "<a href='{$this->getDi()->surl('login')}'>", "</a>");
                    $this->view->display('layout.phtml');
                    return true;
                }
            }
        }
        throw new Am_Exception_InputError(___("Wrong code or code expired. Contact webmaster for details"));
    }
}
