<?php

use League\OAuth2\Server\Entities\ScopeEntityInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\RequestHandlerInterface;

class Am_Oauth_Api_Middleware_Scope
{
    use Am_Oauth_Traits_GetModule;
    
    protected
        $scopes = [];

    /**
     * 
     * @param ScopeEntityInterface[] $scopes
     */
    function __construct($scope)
    {
        if(!is_array($scope))
            $scope = [$scope];
        
        foreach($scope as $v)
        {
            if (is_string($v))
            {
                if($_ = $this->getModule()->getScopeRepository()->getScopeEntityByIdentifier($v))
                    $this->scopes[] = $_;
            }
            else if ($v instanceof ScopeEntityInterface)
            {
                $this->scopes[] = $v;
            }else
                throw new Am_Exception_InternalError(___('Wrong parameters passed'));
            
        }
    }

    function __invoke(ServerRequestInterface $request, RequestHandlerInterface $handler) : ResponseInterface
    {

        
        try
        {
            $scopes = $request->getScopes();
            $require_scopes = array_map(function($scope)
            {
                return $scope->getIdentifier();
            }, $this->scopes);
            
            if (!array_intersect($require_scopes, (array)$scopes))
                throw new Exception(
                ___("Access denied. You don't have necessary permissions to make this API call. "
                    . "Permissions required: %s", implode(', ', $require_scopes)));
        }
        catch (\Exception $exception)
        {

            return new Am_Oauth_Api_Response_Forbidden($exception->getMessage());
        }

        return $handler->handle($request);
    }

}
