<?php

/**
 * @ApiAllowedGrantTypes GRANT_AUTHORIZATION_CODE, GRANT_PASSWORD, GRANT_CLIENT_CREDENTIALS, GRANT_AMEMBER_DEVICE
 * @ApiBaseEndpoint /available-products
 * @ApiBaseScope available-products
 */
class Am_Oauth_Api_Resource_AvailableProducts extends Am_Oauth_Api_Resource_Object
{
    public function getDescription()
    {
        return ___('Get products available for purchase');
    }

    public function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $categories = $request->getParam('categories');

        if(!empty($categories) && !is_array($categories)){
            $categories = [$categories];
        }

        $userId = $request->getUserId();

        $activeProducts = $expiredProducts = [];

        if($userId){
            $user = $request->getDi()->userTable->load($userId);
            $activeProducts = $user->getActiveProductIds();
            $expiredProducts = $user->getExpiredProductIds();
        }

        $products = $request->getDi()
            ->productTable
            ->filterProducts(
                $request->getDi()->productTable->getVisible($categories),
                $activeProducts,
                $expiredProducts,
                true
            );
        $data = [];
        foreach($products as $product)
        {
            $pr = new stdClass();
            foreach(['product_id', 'title', 'description'] as $key)
            {
                $pr->{$key} = $product->get($key);
            }
            $pr->categories = $product->getCategories();
            $pr->billing_plans = $product->getBillingOptions();
            $data[] = $pr;
        }
        return $response->withSuccessData($data);
    }
}
