<?php

/**
 * @ApiBaseEndpoint /me
 * @ApiAllowedGrantTypes GRANT_PASSWORD GRANT_AUTHORIZATION_CODE
 */
class Am_Oauth_Api_Resource_Me extends Am_Oauth_Api_Resource_Object
{

    const AM_SCOPE_PROFILE = 'me.profile';
    const AM_SCOPE_FULLPROFILE = 'me.fullprofile';
    const AM_SCOPE_SUBSCRIPTIONS = 'me.subscriptions';
    const AM_SCOPE_RESOURCES = 'me.resources';

    public function setupScopes()
    {
        $this->scopes = [
            new OauthScope(
                self::AM_SCOPE_PROFILE,
                ___('Basic User profile information(login, name, email)'),
                [
                    Bootstrap_Oauth::GRANT_PASSWORD,
                    Bootstrap_Oauth::GRANT_AUTHORIZATION_CODE,
                ]),
            new OauthScope(
                self::AM_SCOPE_FULLPROFILE,
                ___('Full profile information, with address info'),
                [
                    Bootstrap_Oauth::GRANT_PASSWORD,
                    Bootstrap_Oauth::GRANT_AUTHORIZATION_CODE,
                ]),
            new OauthScope(
                self::AM_SCOPE_SUBSCRIPTIONS,
                ___('Information about active subscirptions and access expiration dates'),
                [
                    Bootstrap_Oauth::GRANT_PASSWORD,
                    Bootstrap_Oauth::GRANT_AUTHORIZATION_CODE,
                ]),
            new OauthScope(
                self::AM_SCOPE_RESOURCES,
                ___('Information about resources available to user on site(protected folders, files, videos)'),
                [
                    Bootstrap_Oauth::GRANT_PASSWORD,
                    Bootstrap_Oauth::GRANT_AUTHORIZATION_CODE,
                ]),
        ];
    }


    function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $this->getDi()->userTable->load($request->getUserId());
        $data = [];

        if ($request->haveScope(self::AM_SCOPE_FULLPROFILE)) {
            $data = $user->toArray();
        } else {
            if ($request->haveScope(self::AM_SCOPE_PROFILE)) {
                $data = [
                    'id' => $user->pk(),
                    'login' => $user->login,
                    'name_f' => $user->name_f,
                    'name_l' => $user->name_l,
                    'email' => $user->email,
                ];
            }
        }

        if (!empty($data)) {
            $data ['groups'] = $user->getGroups();
        }

        if ($request->haveScope(self::AM_SCOPE_SUBSCRIPTIONS)) {
            $data['subscriptions'] = $user->getActiveProductsExpiration();
            $data['categories'] = $user->getActiveCategoriesExpiration();
        }

        if ($request->haveScope(self::AM_SCOPE_RESOURCES)) {
            $resources =
                $this->getDi()
                    ->resourceAccessTable
                    ->getAllowedResources($user, ResourceAccess::USER_VISIBLE_TYPES);

            $res = [];
            foreach ($resources as $r) {
                if (($link = $r->renderLink())) {
                    $res[] = $link;
                }
            }

            $data['resources'] = $res;
        }

        return $response->withSuccessData($data);
    }
    function getValidateScopesCallback($method)
    {
        return new Am_Oauth_Api_Middleware_Scope($this->getScopes());
    }
}