<?php
/**
 * Retrieve user access records;
 * GET /api2/user/access
 *
 * @ApiAllowedGrantTypes GRANT_AUTHORIZATION_CODE, GRANT_PASSWORD
 * @ApiBaseEndpoint /user/access
 * @ApiBaseScope user.access
 */
class Am_Oauth_Api_Resource_UserAccess extends Am_Oauth_Api_Resource_Object
{
    public function getDescription()
    {
        return ___('Get information about access records');
    }

    function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $this->getDi()->userTable->load($request->getUserId());
        return $response->withSuccessData($user->getAccessRecords());
    }
}
