<?php

/**
 * @ApiAllowedGrantTypes GRANT_AUTHORIZATION_CODE, GRANT_PASSWORD
 * @ApiBaseEndpoint /user/consent
 * @ApiBaseScope user.consent
 */
class Am_Oauth_Api_Resource_UserConsent  extends Am_Oauth_Api_Resource_Object
{

    public function getDescription()
    {
        return ___('Get/set user consent');
    }

    function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();
        $ret = [];
        foreach($request->getDi()->agreementTable->getTypes() as $type)
        {
            $agreement = $request->getDi()->agreementTable->getCurrentByType($type);
            $ret[$type] = $this->getDi()->userConsentTable->findFirstBy([
                'user_id' => $user->pk(),
                'revision_id' =>$agreement->agreement_revision_id
                ]);
        }
        return $response->withSuccessData($ret);
    }

    function post(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();
        $type = $request->getParam('type');
        if(empty($type))
        {
            return new Am_Oauth_Api_Response_ValidationError(___("type can't be empty"));
        }

        $document = $request->getDi()->agreementTable->getCurrentByType($type);

        if(empty($document))
        {
            return new Am_Oauth_Api_Response_ValidationError(___("Unable to find current version of document for this type"));
        }

        $consent = $request->getDi()->userConsentTable->recordConsent(
            $user,
            $type,
            $request->getClientIp(),
            ___('Received from Oauth App: %s', $request->getAttribute('oauth_client_id')),
            $document->title
            );

        return $response->withSuccessData($consent);
    }

    function delete(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();
        $type = $request->getParam('type');
        if(empty($type))
        {
            return new Am_Oauth_Api_Response_ValidationError(___("type can't be empty"));
        }

        $document = $request->getDi()->agreementTable->getCurrentByType($type);

        if(empty($document))
        {
            return new Am_Oauth_Api_Response_ValidationError(___("Unable to find current version of document for this type"));
        }

        $request->getDi()->userConsentTable->cancelConsent(
            $user,
            $type,
            $request->getClientIp(),
            ___('Cancelled from Oauth App: %s', $request->getAttribute('oauth_client_id'))
            );

        return $this->get($request, $response, $args);
    }
}