<?php

/**
 * @ApiAllowedGrantTypes GRANT_AUTHORIZATION_CODE, GRANT_PASSWORD
 * @ApiBaseEndpoint /user/personal-data
 * @ApiBaseScope user.personal-data
 */
class Am_Oauth_Api_Resource_UserPersonalData  extends Am_Oauth_Api_Resource_Object
{
    use Am_PersonalData;
    public
        function getAllowedGrantTypes()
    {
        return [
            Bootstrap_Oauth::GRANT_PASSWORD,
            Bootstrap_Oauth::GRANT_AUTHORIZATION_CODE
        ];
    }

    public function getDescription()
    {
        return ___('Get/Delete user personal data');
    }

    function checkPassword(Am_Oauth_Api_Request $request, User $user)
    {
        $password = $request->getParam('password');
        if(empty($password))
        {
            throw new Am_Exception_InputError(___('Password is missing in incoming request'));
        }

        if(!$user->checkPassword($password))
        {
            throw new Am_Exception_InputError(___('Password is incorrect'));
        }
    }


    function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();

        try
        {
            $this->checkPassword($request, $user);
        }
        catch(Am_Exception $ex)
        {
            return new Am_Oauth_Api_Response_ValidationError($ex->getMessage());
        }

        return $response->withSuccessData($this->buildPersonalDataArray($user));
    }


    function delete(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        $user = $request->getUser();

        try
        {
            $this->checkPassword($request, $user);
        }
        catch(Am_Exception $ex)
        {
            return new Am_Oauth_Api_Response_ValidationError($ex->getMessage());
        }

        if(!$request->getDi()->config->get('enable-account-delete'))
        {
            return new Am_Oauth_Api_Response_ValidationError(___('Personal Data Delete is disabled in config'));
        }

        $errors = $this->doAnonymize($user);

        if(!empty($errors))
        {
            $this->addDeleteRequest($user, $errors, $request->getClientIp());
            $this->notifyAdmin($user, $errors);
        }

        return $response->withSuccessData(empty($errors) ? [] : ['errors'=>$errors]);
    }
}

