<?php

/**
 * @ApiAllowedGrantTypes GRANT_AUTHORIZATION_CODE, GRANT_PASSWORD
 * @ApiBaseEndpoint /user/profile
 * @ApiBaseScope user.profile
 *
 */
class Am_Oauth_Api_Resource_UserProfile extends Am_Oauth_Api_Resource_Object
{
    use Am_Oauth_Traits_GetFormErrors;
    use Am_Mvc_Controller_User_Update, Am_Oauth_Traits_HandleEmail{
        Am_Oauth_Traits_HandleEmail::handleEmail insteadof Am_Mvc_Controller_User_Update;
    }

    public function getDescription()
    {
        return ___("Ability to manage(get/update) user's profile information");
    }

    /**
     *
     * @param Am_Oauth_Api_Request $request
     * @return Am_Oauth_Form_Profile $profile - initialized profile form
     * @throws Am_Exception_FatalError if there is no form
     */
    function initProfileForm(Am_Oauth_Api_Request $request)
    {
        $user = $request->getUser();

        $form = new Am_Oauth_Form_Profile();

        $record = $this->getDi()->savedFormTable->getByType('oauth-profile');
        $record = $this->getDi()->hook->filter($record, Am_Event::LOAD_PROFILE_FORM, [
            'request' => $request,
            'user' => $user,
        ]);

        if (!$record)
            throw new Am_Exception_FatalError("No profile form configured");

        $form->initFromSavedForm($record);
        $form->setUser($user);

        $u = $user->toArray();
        unset($u['pass']);


        $form->setDataSources([
            $request,
            new HTML_QuickForm2_DataSource_Array($u)
            ]);
        return $form;

    }
    function get(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        try
        {
            $form = $this->initProfileForm($request);
        } catch (Exception $ex) {
            return new Am_Oauth_Api_Response_FatalError($ex->getMessage());
        }

        $ret = $form->getValue();

        unset($ret['_save_']);

        return $response->withSuccessData($ret);
    }

    function put(Am_Oauth_Api_Request $request, Am_Oauth_Api_Response $response, $args)
    {
        try
        {
            $form = $this->initProfileForm($request);
        } catch (Exception $ex) {
            return new Am_Oauth_Api_Response_FatalError($ex->getMessage());
        }
        $this->getDi()->auth->setUser($request->getUser()); // For email validation
        if(!$form->validate())
        {
            return new \Am_Oauth_Api_Response_ValidationError(
                ___('An error happened when we try to validate your request. Please check hints for more details'),
                $this->getFormErrors($form)
                );
        }

        $vals = $form->getValue();

        unset($vals['user_id']); // No games with user_id;

        $user = $this->updateUser($request->getUser(), $vals, $form);

        if($this->isVerifyEmailState($user))
        {
            return $response->withSuccessData($vals, 200, 'verify-email', ___('Email verification is required'));
        }
        else
        {
            return $this->get($request, $response, $args);
        }

    }

}
