<?php

use Psr\Http\Message\ResponseFactoryInterface;
use Fig\Http\Message\StatusCodeInterface;
use Psr\Http\Message\ResponseInterface;


class Am_Oauth_Api_Response_Factory implements ResponseFactoryInterface
{
    /**
     * {@inheritdoc}
     */
    public function createResponse(
        int $code = StatusCodeInterface::STATUS_OK,
        string $reasonPhrase = ''
    ): ResponseInterface {
        $res = new Am_Oauth_Api_Response($code);
        
        if ($reasonPhrase !== '') {
            $res = $res->withStatus($code, $reasonPhrase);
        }
        
        return $res;
    }
}
