<?php

class Am_Oauth_Form_Signup extends Am_Form_Signup
{
    public function getAvailableBricks()
    {
        $ret = parent::getAvailableBricks();
        foreach ($ret as $k => $brick)
        {
            if (!in_array($brick->getClass(), [
                'name',
                'email',
                'address',
                'login',
                'password',
                'field'
                ]))
                unset($ret[$k]);
        }
        return $ret;
    }

    public function getDefaultBricks()
    {
        return [
            new Am_Form_Brick_Name,
            new Am_Form_Brick_Email,
            new Am_Form_Brick_Login,
            new Am_Form_Brick_Password,
            new Am_Form_Brick_Address,
        ];
    }

    public function isHideBricks()
    {
        return false;
    }

    static function getSavedFormUrl(SavedForm $record)
    {
        if(empty($record->code)){
            return 'api2/register';
        }else{
            return 'api2/register/' . urlencode($record->code);
        }
    }

}