<?php

use League\OAuth2\Server\Grant\ImplicitGrant;
use League\OAuth2\Server\Entities\ClientEntityInterface;
use League\OAuth2\Server\Entities\ScopeEntityInterface;

class Am_Oauth_Grant_Implicit extends ImplicitGrant implements Am_Oauth_Grant_Interface
{
    use Am_Oauth_Traits_ValidateClientId;
    
    public
        function getDescription()
    {
        $url = Am_Di::getInstance()->url('oauth/token');
        return <<<CUT
Implicit Grant Type. Not fully  implemented yet.
CUT;
    }
    /**
     * Issue access token for given user without any checks. 
     * Can be used only internally in php. 
     * @param \DateInterval $accessTokenTTL
     * @param ClientEntityInterface $client
     * @param type $userIdentifier
     * @param ScopeEntityInterface $scopes
     * @return AccessTokenEntityInterface
     */
    function userIssueAccessToken(\DateInterval $accessTokenTTL, ClientEntityInterface $client, $userIdentifier, $scopes)
    {
        return $this->issueAccessToken($accessTokenTTL, $client, $userIdentifier, $scopes)->convertToJWT($this->privateKey);
    }

}

