<?php

use League\OAuth2\Server\Grant\PasswordGrant;

class Am_Oauth_Grant_Password extends PasswordGrant implements Am_Oauth_Grant_Interface
{
    use Am_Oauth_Traits_ValidateClientId;
    
    public
        function getDescription()
    {
        $url = Am_Di::getInstance()->url('oauth/token');
        return <<<CUT
Grant implements an ability to exchange user's login/pasword credentials to authorization token. 
Can be used on trusted clients (both client_id and client_secret should be provided in this situation)
and also in situations  where client_secret can't be shared (for web and mobile apps). client_secret is optional in this case
CUT;
    }
    
    /**
     * Issue access token for given user without any checks. 
     * Can be used only internally in php. 
     * @param \DateInterval $accessTokenTTL
     * @param ClientEntityInterface $client
     * @param type $userIdentifier
     * @param ScopeEntityInterface $scopes
     * @return AccessTokenEntityInterface
     */
    function userIssueAccessToken(\DateInterval $accessTokenTTL, $client, $userIdentifier, $scopes)
    {
        return $this->issueAccessToken($accessTokenTTL, $client, $userIdentifier, $scopes)->convertToJWT($this->privateKey);
    }
    

}
