<?php

use League\OAuth2\Server\Entities\ScopeEntityInterface;

trait Am_Oauth_Traits_Token_Scopes
{

    protected
        $_scopes;

    function addScope(ScopeEntityInterface $scope)
    {
        $this->_scopes[$scope->getIdentifier()] = $scope;

        $scopes = !empty($this->scopes) ? json_decode($this->scopes, true) : [];

        $scopes[] = $scope->getIdentifier();

        $this->scopes = json_encode(array_unique($scopes));
    }

    public
        function getScopes()
    {
        return (array) @json_decode($this->scopes, true);
    }

}
