<?php

use League\OAuth2\Server\Repositories\AuthCodeRepositoryInterface;
use League\OAuth2\Server\Entities\AuthCodeEntityInterface;

class OauthAuthCode extends Am_Record implements AuthCodeEntityInterface
{

    use Am_Oauth_Traits_Token_Revoke,
        Am_Oauth_Traits_Token_Expire,
        Am_Oauth_Traits_Token_Client,
        Am_Oauth_Traits_Token_UserIdentifier,
        Am_Oauth_Traits_Token_Scopes;

    public
        function getIdentifier()
    {
        return $this->auth_code;
    }

    public
        function getRedirectUri()
    {
        return $this->redirect_uri;
    }

    public
        function setIdentifier($identifier)
    {
        $this->auth_code = $identifier;
    }

    public
        function setRedirectUri($uri)
    {
        $this->redirect_uri = $uri;
    }

}

class OauthAuthCodeTable extends Am_Table implements AuthCodeRepositoryInterface
{

    use \Am_Oauth_Traits_Token_CleanUp;

    protected
        $_key = 'oauth_auth_code_id';
    protected
        $_table = '?_oauth_auth_code';
    protected
        $_recordClass = 'OauthAuthCode';

    public
        function getNewAuthCode()
    {
        $authCode = $this->getDi()->oauthAuthCodeRecord;
        return $authCode;
    }

    public
        function isAuthCodeRevoked($codeId)
    {
        $authCodeEntity = $this->findFirstBy(['auth_code' => $codeId]);

        if (!$authCodeEntity)
            return true;

        return $authCodeEntity->isRevoked();
    }

    public
        function persistNewAuthCode(AuthCodeEntityInterface $authCodeEntity)
    {
        $authCodeEntity->save();
    }

    public
        function revokeAuthCode($codeId)
    {
        $authCodeEntity = $this->findFirstBy(['auth_code' => $codeId]);

        if (!$authCodeEntity)
            return;

        $authCodeEntity->revoke();
    }

}
