<?php

use League\OAuth2\Server\Repositories\RefreshTokenRepositoryInterface;
use League\OAuth2\Server\Entities\RefreshTokenEntityInterface;
use League\OAuth2\Server\Entities\AccessTokenEntityInterface;

class OauthRefreshToken extends Am_Record implements RefreshTokenEntityInterface
{

    use Am_Oauth_Traits_Token_Revoke,
        Am_Oauth_Traits_Token_Expire;

    protected
        $_access_token;

    public
        function getAccessToken()
    {
        if (empty($this->_access_token))
            $this->_access_token = $this->getDi()->oauthAccessTokenTable->load($this->oauth_access_token_id);

        return $this->_accessToken;
    }

    public
        function getIdentifier()
    {
        return $this->token;
    }

    public
        function setAccessToken(AccessTokenEntityInterface $accessToken)
    {
        $this->_access_token = $accessToken;

        $this->oauth_access_token_id = $accessToken->pk();
        $this->client_id = $accessToken->client_id;
        $this->user_id = $accessToken->user_id;
        
    }

    public
        function setIdentifier($identifier)
    {
        $this->token = $identifier;
    }

}

class OauthRefreshTokenTable extends Am_Table implements RefreshTokenRepositoryInterface
{

    use \Am_Oauth_Traits_Token_CleanUp;

    protected
        $_key = 'oauth_refresh_token_id';
    protected
        $_table = '?_oauth_refresh_token';
    protected
        $_recordClass = 'OauthRefreshToken';

    public
        function getNewRefreshToken()
    {
        return $this->getDi()->oauthRefreshTokenRecord;
    }

    public
        function isRefreshTokenRevoked($tokenId)
    {
        $refresh_token = $this->findFirstBy(['token' => $tokenId]);
        
        if(!$refresh_token)
            return true;
        
        return $refresh_token->isRevoked();
    }

    public
        function persistNewRefreshToken(RefreshTokenEntityInterface $refreshTokenEntity)
    {
        $refreshTokenEntity->save();
    }

    public
        function revokeRefreshToken($tokenId)
    {
        $refresh_token = $this->findFirstBy(['token' => $tokenId]);
        
        if(!$refresh_token)
            return;
        
        $refresh_token->revoke();
    }

}
