<?php

/** @help-id PluginDocs/Modules/Oauth */
class Am_Form_Setup_Oauth extends Am_Form_Setup
{

    function __construct()
    {
        parent::__construct('oauth');
        $this->setTitle(___('OAuth2 Server'));
    }

    function initElements()
    {
        $this->addText('oauth.private_key', ['class' => 'dir-browser', 'size'=>50])
            ->setLabel(___("Private Key Path\n"
                . "path where you have uploaded your private.key"));

        $this->addText('oauth.public_key', ['class' => 'dir-browser', 'size'=>50])
            ->setLabel(___("Public Key Path\n"
                . "path where you have uploaded your public.key"));

        $this->addScript('script')->setScript('jQuery(function(){jQuery(".dir-browser").dirBrowser();});');

        $this->addText('oauth.access_token_lifetime', ['size'=>5])
            ->setLabel(___("Access Token LifeTime, hours\n"
                . "Number of hours, or PHP DateInterval format string\n"
                . "Default value is 1 one hour)"));

        $this->addText('oauth.refresh_token_lifetime', ['size'=>5])
            ->setLabel(___("Refresh Token LifeTime, days\n"
                . "Number of days, or PHP DateInterval format string\n"
                . "Default value is 30 days"));

        $this->addAdvCheckbox('oauth.require_device')
            ->setLabel(___("Require Device Registration\n"
                . "In order to receive access token, "
                . "client must register device on the server"));

        $this->addElement('email_link', 'oauth.confirm_email', null, ['help-id' => '#Validation_Message_Configuration'])
            ->setLabel(___("Email confirmation message that will be sent customer\n".
                "e-mail confirmation should be enabled for oauth-registration and profile forms\n".
                "at aMember CP -> Forms Editor -> Edit, click \"configure\" on E-Mail brick"));
        
        $this->addAdvCheckbox('oauth.enable_pkce')
            ->setLabel(___("Enable PKCE support
            Please note: When enabled, code_challenge and code_challenge_method parameters
            will be required in Authorization request. If you have existing integration that use AuthCode flow,
            you need to add PKCE support to clients first. %s
            ", "<a href='https://www.oauth.com/oauth2-servers/pkce/authorization-request/'>more info abot PKCE</a>"));

        $this->setDefault('oauth.access_token_lifetime', Bootstrap_Oauth::CONFIG_ACCESS_TOKEN_DEFAULT_LIFETIME);
        $this->setDefault('oauth.refresh_token_lifetime', Bootstrap_Oauth::CONFIG_REFRESH_TOKEN_DEFAULT_LIFETIME);
    }
}

