package co.pixelbeard.theanfieldwrap.data.responses;

import com.google.gson.annotations.SerializedName;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.networking.BaseResponse;

public class PodcastsResponse extends BaseResponse {

    @SerializedName("context")
    String context;
    @SerializedName("feed")
    List<Podcast> podcasts;

    public PodcastsResponse() {
    }

    public PodcastsResponse(boolean success, String message, String context, List<Podcast> podcasts) {
        this.setSuccess(success);
        this.setMessage(message);
        this.context = context;
        this.podcasts = podcasts;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public List<Podcast> getPodcasts() {
        return podcasts;
    }

    public void setPodcasts(List<Podcast> podcasts) {
        this.podcasts = podcasts;
    }
}
