package co.pixelbeard.theanfieldwrap.devices;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Device;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface DevicesContract {

    interface View extends BaseView<Presenter> {
        void setDevicesAdapter(List<Device> devices);

        void finishDevicesActivityWithUnlinkedResult();

        void finishDevicesActivityWithNoResult();

        void showSingleButtonDialog(String title, String message);

        void removeItemFromAdapter(int position);

    }

    interface Presenter extends BasePresenter {
        void getDevices(List<Device> devices);

        void unlinkDevice(Device device, int position);
    }
}