package co.pixelbeard.theanfieldwrap.dialog.unlockEpisodes;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Point;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.PrefKey;
import co.pixelbeard.theanfieldwrap.utils.PrefUtils;

public class UnlockEpisodeDialog extends Dialog {

    @BindView(R.id.img_close)
    ImageView imgClose;
    @BindView(R.id.txt_unlock_to_hear_more)
    TextView txtUnlockToHearMore;
    @BindView(R.id.txt_unlock_to_hear_more_body)
    TextView txtUnlockToHearMoreBody;
    @BindView(R.id.btn_how_to_subscribe)
    Button btnHowToSubscribe;
    @BindView(R.id.ll_buy_episode)
    LinearLayout llBuyEpisode;
    @BindView(R.id.txt_podcast_cost)
    TextView txtPodcastCost;
    @BindView(R.id.img_token)
    ImageView imgToken;

    private Context mContext;
    private UnlockEpisodeListener mListener;
    private Podcast mPodcast;

    public UnlockEpisodeDialog(@NonNull Context context, UnlockEpisodeListener listener, Podcast podcast) {
        super(context);

        this.mContext = context;
        this.mListener = listener;
        this.mPodcast = podcast;
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        Window window = getWindow();

        if (window != null) {
            window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
            window.getAttributes().windowAnimations = R.style.TAWDialogAnimationStyle;
        }

        setContentView(R.layout.dialog_unlock_to_hear_more);
        setDialogSize();

        ButterKnife.bind(this);

        setTextViewFonts();
        setButtonFonts();
        setClickListeners();

        if (PrefUtils.getInstance().getBooleanPref(PrefKey.IS_GUEST_ACCOUNT)) {
            imgToken.setVisibility(View.GONE);
            txtPodcastCost.setText(R.string.create_full_account);
        } else {
            txtPodcastCost.setText(String.format(mContext.getString(R.string.tokens_argument), mPodcast.getCost()));
        }
    }

    private void setTextViewFonts() {
        txtUnlockToHearMore.setTypeface(FontUtils.getInstance().getDinProBlack());
        txtUnlockToHearMoreBody.setTypeface(FontUtils.getInstance().getArialReg());
    }

    private void setButtonFonts() {
        btnHowToSubscribe.setTypeface(FontUtils.getInstance().getDinAlternateBold());
        txtPodcastCost.setTypeface(FontUtils.getInstance().getDinAlternateBold());

    }

    private void setClickListeners() {
        View.OnClickListener listener = v -> dismiss();

        imgClose.setOnClickListener(listener);

        llBuyEpisode.setOnClickListener(v -> {
            if (PrefUtils.getInstance().getBooleanPref(PrefKey.IS_GUEST_ACCOUNT)) {
                mListener.createAccountClicked();
                dismiss();
            } else {
                mListener.purchasePodcastClicked();
                dismiss();
            }
        });

        btnHowToSubscribe.setOnClickListener(v -> {
            mListener.howToSubscribeClicked();
            dismiss();
        });
    }

    private void setDialogSize() {

        WindowManager manager = (WindowManager) mContext.getSystemService(Activity.WINDOW_SERVICE);
        int width, height;

        Point point = new Point();
        manager.getDefaultDisplay().getSize(point);
        width = point.x;
        height = point.y;

        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(this.getWindow().getAttributes());
        lp.width = width;
        this.getWindow().setAttributes(lp);
    }
}
