package co.pixelbeard.theanfieldwrap.downloader;

import android.content.Context;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Fetch;
import com.tonyodev.fetch2.Request;

import java.util.ArrayList;
import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Podcast;
import rx.subjects.PublishSubject;


public class DownloadManager {

    private static final String TAG = DownloadManager.class.getSimpleName();
    private static DownloadManager instance = null;

    private Fetch fetch;
    private PublishSubject<Download> data;

    private DownloadManager() {
        fetch = Fetch.Impl.getDefaultInstance();
        data = PublishSubject.create();

    }

    public static synchronized DownloadManager getInstance() {
        if (instance == null) {
            instance = new DownloadManager();
        }
        return instance;
    }

    public void download(Podcast podcast, Context context) {
        if (podcast == null) {
            return;
        }
        final Request request = new Request(podcast.getPodcastFullUrl(),
                DownloadConstants.getFilePath("TheAnfieldWrap_podcast_ID_" + podcast.getPostId(),
                        context));

        request.setGroupId(189345);

        List<Request> requests = new ArrayList<>();
        requests.add(request);
        fetch.enqueue(requests, updatedRequests -> {
        });
    }

}
