package co.pixelbeard.theanfieldwrap.editPassword;

import android.content.Context;
import android.os.Handler;
import android.util.Log;

import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.networking.CallbackWrapper;
import co.pixelbeard.theanfieldwrap.utils.ValidationUtils;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class EditPasswordPresenter implements EditPasswordContract.Presenter {

    private EditPasswordContract.View mView;
    private DataRepository mRepo;

    public EditPasswordPresenter(EditPasswordContract.View view, DataRepository repo) {
        if (view != null && repo != null) {
            this.mView = view;
            this.mRepo = repo;

            mView.setPresenter(this);
        }
    }


    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {

    }

    @Override
    public void clearUserData(Context context) {
        mRepo.logout().subscribe(new Observer<GenericResponse>() {
            @Override
            public void onSubscribe(Disposable d) {

            }

            @Override
            public void onNext(GenericResponse genericResponse) {
                Log.d("LOGOUT", genericResponse.getMessage());
            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onComplete() {

            }
        });
        //TODO test this
//        mRepo.clearAllData(context);
    }

    @Override
    public boolean validateFields(String currentPassword, String newPassword, String confirmPassword, boolean shouldShowError) {

        boolean valid = true;

        if (currentPassword == null || currentPassword.length() < 6) {
            valid = false;

            if (shouldShowError) {
                mView.showCurrentPasswordError();
            }
        } else if (!ValidationUtils.isValidPassword(newPassword)) {
            valid = false;

            if (shouldShowError) {
                mView.showInvalidPasswordError();
            }
        } else if (!newPassword.equals(confirmPassword)) {
            valid = false;
            if (shouldShowError) {
                mView.showPasswordsDontMatchError();
            }
        }

        if (valid) {
            mView.enableButton();
        } else {
            mView.disableButton();
        }

        return valid;
    }

    @Override
    public void changePassword(String oldPassword, String newPassword) {


        if (mView != null && mView.checkConnection()) {
            mView.showLoader("");
            mRepo.changePassword(oldPassword, newPassword).subscribe(new CallbackWrapper<GenericResponse>(mView) {
                @Override
                protected void onSuccess(GenericResponse genericResponse) {
                    new Handler().postDelayed(() -> mView.goBack(), 400);
                }

                @Override
                protected void onSuccessFalse(GenericResponse genericResponse) {
                    new Handler().postDelayed(() -> {
                        if (mView != null) {
                            if (genericResponse.getMessage().equals("The old password is incorrect")) {
                                mView.showIncorrectPasswordError();
                            } else {
                                mView.showSingleButtonDialog("Error", genericResponse.getMessage());
                            }
                        }
                    }, 400);
                }
            });

        } else {
            if (mView != null) {
                mView.onConnectionError();
            }
        }
    }

    @Override
    public void backClicked() {
        if (mView != null) {
            mView.goBack();
        }
    }

    @Override
    public void saveClicked(String currentPassword, String newPassword, String confirmPassword) {
        if (validateFields(currentPassword, newPassword, confirmPassword, true)) {
            changePassword(currentPassword, confirmPassword);
        }
    }
}
