package co.pixelbeard.theanfieldwrap.forgotPassword.fpAuth;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.rw.keyboardlistener.KeyboardUtils;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.customView.PBInputField;
import co.pixelbeard.theanfieldwrap.forgotPassword.ForgotPasswordFragmentListener;
import co.pixelbeard.theanfieldwrap.utils.BaseFragment;
import co.pixelbeard.theanfieldwrap.utils.ConnectionUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.TawController;


public class ForgotPasswordAuthFragment extends BaseFragment implements ForgotPasswordAuthContract.View {

    private static final String TAG = ForgotPasswordAuthFragment.class.getSimpleName();

    @BindView(R.id.pb_auth_code)
    PBInputField pbAuthCode;

    private ForgotPasswordFragmentListener mListener;
    private Context mContext;
    private ForgotPasswordAuthContract.Presenter mPresenter;


    public ForgotPasswordAuthFragment() {
        // Required empty public constructor
    }

    public static ForgotPasswordAuthFragment newInstance() {
        ForgotPasswordAuthFragment fragment = new ForgotPasswordAuthFragment();
        Bundle args = new Bundle();

        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        mListener = (ForgotPasswordFragmentListener) context;
        mContext = context;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
        }

        new ForgotPasswordAuthPresenter(this);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_forgot_password_auth, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);


        setInputFieldFont();
        setInputFieldImeListener();
        setInputFieldTextWatcher();

        mPresenter.validateFields(pbAuthCode.getText(), false);
    }

    @Override
    public void onResume() {
        super.onResume();
        TawController.setCurrentPage(TAG);
    }

    private void setInputFieldFont() {
        pbAuthCode.setInputType(InputType.TYPE_CLASS_TEXT);
        pbAuthCode.setTooltipTypeface(FontUtils.getInstance().getDinAlternateBold());
        pbAuthCode.setEditTextTypeface(FontUtils.getInstance().getDinAlternateBold());
        pbAuthCode.setTextInputTypeface(FontUtils.getInstance().getDinAlternateBold());
    }


    private void setInputFieldImeListener() {
        pbAuthCode.setImeActionListener((v, actionId, event) -> {
            KeyboardUtils.forceCloseKeyboard(pbAuthCode);
            return true;
        });
    }

    private void setInputFieldTextWatcher() {
        pbAuthCode.setTextWatcher(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                pbAuthCode.resetError();
                mPresenter.validateFields(pbAuthCode.getText(), false);
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });
    }

    @Override
    public void isValidated() {
        boolean validated = true;

        if (!mPresenter.validateFields(pbAuthCode.getText(), true)) {
            validated = false;
        }

        if (validated && mListener != null) {
            mListener.setConfirmationCode(pbAuthCode.getText());
            mListener.setForgotPasswordNewPasswordFrag();
        }
    }

    @Override
    public void showInvalidCodeError() {
        if (pbAuthCode != null && isAdded()) {
            pbAuthCode.showError(getString(R.string.invalid_auth_code));
        }

    }

    @Override
    public void enableButton() {
        if (mListener != null && isAdded()) {
            mListener.enableButton();
        }
    }

    @Override
    public void disableButton() {
        if (mListener != null && isAdded()) {
            mListener.disableButton();
        }
    }

    @Override
    public void setPresenter(ForgotPasswordAuthContract.Presenter presenter) {
        if (presenter != null) {
            this.mPresenter = presenter;
        } else {
            throw new RuntimeException("Presenter is null");
        }
    }

    @Override
    public void goBack() {
        //Not needed
    }

    @Override
    public void showLoader(String text) {
        //Not needed
    }

    @Override
    public void hideLoader() {
        //Not needed
    }


    @Override
    public void onUnknownError(String error) {
        //Not needed
    }

    @Override
    public void onTimeout() {
        //Not needed
    }

    @Override
    public void onNetworkError() {
        //Not needed
    }

    @Override
    public void onConnectionError() {
        //Not needed
    }

    @Override
    public void logoutUser() {
        //Not needed
    }

    @Override
    public boolean checkConnection() {
        return ConnectionUtils.userHasConnection(mContext);
    }
}
