package co.pixelbeard.theanfieldwrap.freeSubscription;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.viewpager2.adapter.FragmentStateAdapter;

import java.util.List;

public class SubscriptionViewPager extends FragmentStateAdapter {

    private List<SubscriptionModel> dataList;

    public SubscriptionViewPager(@NonNull FragmentManager fragmentManager, @NonNull Lifecycle lifecycle, List<SubscriptionModel> dataList) {
        super(fragmentManager, lifecycle);
        this.dataList = dataList;
    }

    @NonNull
    @Override
    public Fragment createFragment(int position) {
        return SubscriptionPackageFragment.getInstance(dataList.get(position));
    }

    @Override
    public int getItemCount() {
        return dataList.size();
    }
}