package co.pixelbeard.theanfieldwrap.home;

import android.content.Context;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.responses.SubscriptionItemResponse;
import co.pixelbeard.theanfieldwrap.data.source.DataSource;
import co.pixelbeard.theanfieldwrap.freeSubscription.ActiveSubscriptionResponse;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface HomeContract {

    interface View extends BaseView<Presenter> {
        void setPodcastsFrag();

        void setVideosFrag();

        void setWritingFrag();

        void setProfileFrag();

        void consumeToken(String token);

        void subscriptionItem(SubscriptionItemResponse item);

        void onActivePaidSubscription(ActiveSubscriptionResponse response);
    }

    interface Presenter extends BasePresenter {
        void podcastsClicked();

        void videosClicked();

        void writingClicked();

        void profileClicked();

        void recordAnalytic(String type, String variable, String secondVar);

        void creditAccount(int value, String title, String purchaseToken);

        void checkPodcastStatesForUserId(long userId);

        void checkDownloadsForUserId(long userId, Context context);

        void clearPodcastStates();

        void getPodcastState(long podcastId, int position, DataSource.PodcastStateCallback callback);


        void checkNotifications();

        void getSubscriptionList();

        void activatePaidSubscription(String subscription_plan, String planType, int duration, String purchaseToken);
    }
}