package co.pixelbeard.theanfieldwrap.howToSubscribe;


import android.content.Context;
import android.os.Bundle;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.home.HomeFragmentListener;
import co.pixelbeard.theanfieldwrap.utils.BaseFragment;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.TawController;

public class HowToSubscribeFragment extends BaseFragment {

    private static final String TAG = HowToSubscribeFragment.class.getSimpleName();

    @BindView(R.id.ll_back)
    LinearLayout llBack;
    @BindView(R.id.txt_how_to_subscribe_title)
    TextView txtHowToSubscribeTitle;
    @BindView(R.id.txt_subscribe_content)
    TextView txtSubscribeContent;

    private HomeFragmentListener mListener;

    public HowToSubscribeFragment() {
        // Required empty public constructor
    }

    public static HowToSubscribeFragment newInstance() {
        HowToSubscribeFragment fragment = new HowToSubscribeFragment();
        Bundle args = new Bundle();

        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        mListener = (HomeFragmentListener) context;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {

        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_how_to_subscribe, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        setTextViewFonts();
        setClickListeners();

        String subText = "Subscribe to The Anfield Wrap's subscription service as we share the experience of supporting Liverpool FC from the heart of the city. <br />" +
                "<br /><strong>Gain access to all of our content in 3 steps</strong><br />" +
                "<br />" +
                "1) Visit <a href=\"https://theanfieldwrap.com/taw_subscribe.php\">theanfieldwrap.com/taw_subscribe.php</a> in your web browser<br />" +

                "2) Fill out the subscription form, using the same login as you have used to create an account within this app.<br />" +

                "3) Once complete, return to this app, go to your profile and double check that your subscription has updated.<br /><br />" +

                "That's it! You'll able to enjoy all of our content in one place.";

        txtSubscribeContent.setText(Html.fromHtml(subText));
        txtSubscribeContent.setMovementMethod(LinkMovementMethod.getInstance());
        txtSubscribeContent.setLinksClickable(true);

    }

    @Override
    public void onResume() {
        super.onResume();
        TawController.setCurrentPage(TAG);
    }

    private void setTextViewFonts() {
        txtHowToSubscribeTitle.setTypeface(FontUtils.getInstance().getDinProBlack());
        txtSubscribeContent.setTypeface(FontUtils.getInstance().getArialReg());
    }

    private void setClickListeners() {
        llBack.setOnClickListener(v -> mListener.goBack());
    }

}
