package co.pixelbeard.theanfieldwrap.podcasts;

import android.content.Context;

import com.tonyodev.fetch2.Download;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.data.RealmPodcast;
import co.pixelbeard.theanfieldwrap.data.Subscription;
import co.pixelbeard.theanfieldwrap.data.User;
import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;
import io.realm.RealmResults;

public interface PodcastsContract {

    interface View extends BaseView<Presenter> {
        void setPodcastsAdapter(List<Podcast> podcasts, Podcast featuredPodcast);

        void setDownloadedPodcastsAdapter(RealmResults<RealmPodcast> podcasts);

        void showNoConnectionUi();

        void showNoConnectionHeader();

        void showUi();

        void setSwipeRefreshRefreshing(boolean refreshing);

        void updateUI(Download download);

        void addDownload(Download download);

        void showSingleButtonDialog(String error, String message);

        void checkSubscriptionResponse(User response);

    }

    interface Presenter extends BasePresenter {
        void getPodcasts(int pageNum);

        void checkUserSubs();

        void getDownloadedPodcasts();

        void refreshPodcasts();

        void downloadPodcast(Podcast podcast, Context context);

        void recordAnalytic(String type, String variable, String secondVar);

        RealmPodcast getPodcastById(long id);

        void savePodcast(Podcast podcast, Download download);

    }
}