package co.pixelbeard.theanfieldwrap.signUp;

import android.content.DialogInterface;

import androidx.fragment.app.FragmentManager;

import co.pixelbeard.theanfieldwrap.utils.BasePresenter;
import co.pixelbeard.theanfieldwrap.utils.BaseView;

public interface SignUpContract {

    interface View extends BaseView<Presenter> {
        void setSignUpAuthCodeFrag();

        void showCodeResentToast();

        void showErrorSendingCodeToast();

        void showNoConnectionHeader();

        void showSingleButtonDialog(String title, String body, DialogInterface.OnDismissListener listener);
    }

    interface Presenter extends BasePresenter {
        void backClicked();

        void nextClicked(FragmentManager fragMan);

        void registerUser(String firstName, String lastName, String email, String password, String country, boolean optIn, String username);

        void resendActivationCode(String email);

        void convertGuestToFullUser(String firstName, String lastName, String email, String password, String country, boolean optIn, String username);
    }
}