package co.pixelbeard.theanfieldwrap.signUp;

import android.content.Context;
import android.os.Handler;

import androidx.fragment.app.FragmentManager;

import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.responses.RegisterUserResponse;
import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.networking.CallbackWrapper;
import co.pixelbeard.theanfieldwrap.utils.BaseFragment;
import co.pixelbeard.theanfieldwrap.utils.FragmentUtils;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

/**
 * Created by Michael Stoddart
 * 21/12/2018.
 */
public class SignUpPresenter implements SignUpContract.Presenter {

    private SignUpContract.View mView;
    private DataRepository mRepo;

    public SignUpPresenter(SignUpContract.View view, DataRepository repo) {
        if (view != null && repo != null) {
            this.mView = view;
            this.mRepo = repo;

            mView.setPresenter(this);
        }
    }


    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {
        mView = null;
        mRepo = null;
    }

    @Override
    public void clearUserData(Context context) {
        //Not needed
    }

    @Override
    public void backClicked() {
        mView.goBack();
    }

    @Override
    public void nextClicked(FragmentManager fragMan) {
        if (mView != null && mView.checkConnection()) {
            BaseFragment fragment = FragmentUtils.getCurrentlyAttachedFragment(fragMan);

            if (fragment != null) {
                fragment.isValidated();
            }
        } else {
            if (mView != null) {
                mView.showNoConnectionHeader();
            }
        }
    }

    @Override
    public void registerUser(String firstName, String lastName, String email, String password, String country, boolean optIn, String username) {
        if (mView != null && mView.checkConnection()) {

            mView.showLoader("");
            mRepo.registerFullUser(firstName, lastName, email, password, optIn, username, country).subscribe(new CallbackWrapper<RegisterUserResponse>(mView) {
                @Override
                protected void onSuccess(RegisterUserResponse registerUserResponse) {
                    new Handler().postDelayed(() -> {
                        if (mView != null)
                            mView.setSignUpAuthCodeFrag();
                    }, 300);
                }

                @Override
                protected void onSuccessFalse(RegisterUserResponse registerUserResponse) {
                    mView.showSingleButtonDialog("Error", registerUserResponse.getMessage(), null);
                }
            });

        } else {
            if (mView != null) {
                mView.showNoConnectionHeader();
            }
        }
    }

    @Override
    public void resendActivationCode(String email) {
        if (mView != null && mView.checkConnection()) {
            mRepo.resendAuthCode(email).subscribe(new CallbackWrapper<GenericResponse>(mView) {
                @Override
                protected void onSuccess(GenericResponse genericResponse) {
                    mView.showCodeResentToast();
                }

                @Override
                protected void onSuccessFalse(GenericResponse genericResponse) {
                    mView.showErrorSendingCodeToast();
                }
            });

        } else {
            if (mView != null) {
                mView.showNoConnectionHeader();
            }
        }
    }

    @Override
    public void convertGuestToFullUser(String firstName, String lastName, String email, String password, String country, boolean optIn, String username) {
        if (mView != null && mView.checkConnection()) {
            mView.showLoader("");
            mRepo.convertGuestToFullUser(firstName, lastName, email, password, optIn, username, country).subscribe(new CallbackWrapper<GenericResponse>(mView) {
                @Override
                protected void onSuccess(GenericResponse genericResponse) {
                    logout();
                    new Handler().postDelayed(() -> {
                        if (mView != null)
                            mView.setSignUpAuthCodeFrag();
                    }, 300);
                }

                @Override
                protected void onSuccessFalse(GenericResponse genericResponse) {
                    mView.showSingleButtonDialog("Error", genericResponse.getMessage(), null);
                }
            });

        } else {
            if (mView != null)
                mView.showNoConnectionHeader();
        }
    }

    private void logout() {
        mRepo.logout().subscribe(new Observer<GenericResponse>() {
            @Override
            public void onSubscribe(Disposable d) {

            }

            @Override
            public void onNext(GenericResponse genericResponse) {
                //Doesnt matter at this point we just want to clear the local
            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onComplete() {

            }
        });
    }

}
