package co.pixelbeard.theanfieldwrap.utils;

import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.TranslateAnimation;

import co.pixelbeard.theanfieldwrap.R;

/**
 * Created by Michael Stoddart
 * 18/12/2018.
 */
public class AnimUtils {


    public static void startTranslateAlphaEntryAnimationSet(View view, float fromY, float toY, Animation.AnimationListener listener) {

        if (view.getVisibility() != View.VISIBLE) {
            AnimationSet set = new AnimationSet(true);

            Animation alpha = new AlphaAnimation(0.0f, 1.0f);
            alpha.setDuration(400);
            alpha.setFillAfter(true);

            set.addAnimation(alpha);

            Animation trAnimation = new TranslateAnimation(0, 0, fromY, toY);
            trAnimation.setDuration(400);

            set.addAnimation(trAnimation);

            if (listener != null) {
                alpha.setAnimationListener(listener);
            } else {
                alpha.setAnimationListener(new Animation.AnimationListener() {
                    @Override
                    public void onAnimationStart(Animation animation) {

                    }

                    @Override
                    public void onAnimationEnd(Animation animation) {
                        view.setVisibility(View.VISIBLE);
                    }

                    @Override
                    public void onAnimationRepeat(Animation animation) {

                    }
                });
            }

            set.setInterpolator(new OvershootInterpolator());
            view.startAnimation(set);
        }
    }

    public static void colorChangeAnim(int colorFrom, int colorTo, View view, int duration) {


        ValueAnimator colorAnimation = ValueAnimator.ofObject(new ArgbEvaluator(), colorFrom, colorTo);
        colorAnimation.setDuration(duration);
        colorAnimation.addUpdateListener(animator -> view.setBackgroundColor((int) animator.getAnimatedValue()));
        colorAnimation.start();


    }

    public static void slideOutBottom(View view, int duration, Animation.AnimationListener listener) {
        if (view.getVisibility() == View.VISIBLE) {
            Animation trAnimation = new TranslateAnimation(0, 0, 0, view.getHeight());
            trAnimation.setDuration(duration);
            trAnimation.setInterpolator(new AccelerateInterpolator());

            trAnimation.setAnimationListener(listener);
            view.startAnimation(trAnimation);
        }
    }

    public static void slideOutTop(View view, int duration, Animation.AnimationListener listener) {
        if (view.getVisibility() == View.VISIBLE) {
            Animation trAnimation = new TranslateAnimation(0, 0, 0, -view.getHeight());
            trAnimation.setDuration(duration);
            trAnimation.setInterpolator(new AccelerateInterpolator());

            trAnimation.setAnimationListener(listener);
            view.startAnimation(trAnimation);
        }
    }

    public static void horizontalTranslate(View view, float xBy) {

        view.animate()
                .x(xBy)
                .setInterpolator(new OvershootInterpolator(0.7f))
                .setDuration(200)
                .start();
    }

    public static void animateTabBar(View imageView, View indicator) {
        float centreX = imageView.getX() + imageView.getWidth() / 2;

        indicator.animate()
                .x(centreX - (indicator.getWidth() / 2))
                .setInterpolator(new OvershootInterpolator(0.7f))
                .setDuration(100)
                .start();
    }


    public static void slideInBottom(View view, int duration, Animation.AnimationListener listener, Interpolator interpolator) {
        if (view.getVisibility() != View.VISIBLE) {
            Animation trAnimation = new TranslateAnimation(0, 0, view.getHeight(), 0);
            trAnimation.setDuration(duration);
            trAnimation.setInterpolator(interpolator);

            trAnimation.setAnimationListener(listener);

            view.startAnimation(trAnimation);
        }
    }

    public static void slideInTop(View view, int duration, Animation.AnimationListener listener, Interpolator interpolator) {
        if (view.getVisibility() != View.VISIBLE) {
            Animation trAnimation = new TranslateAnimation(0, 0, -view.getHeight(), 0);
            trAnimation.setDuration(duration);
            trAnimation.setInterpolator(interpolator);

            trAnimation.setAnimationListener(listener);

            view.startAnimation(trAnimation);
        }
    }

    public static Animation getPulsateFade(Context con) {
        return AnimationUtils.loadAnimation(con, R.anim.pulsate_fade);
    }

    public static Animation getPulsateFadeLoader(Context con) {
        return AnimationUtils.loadAnimation(con, R.anim.pulsate_fade_loader);
    }

}
