package co.pixelbeard.theanfieldwrap.utils;

import android.content.Context;
import android.net.ConnectivityManager;

import java.io.IOException;

public class ConnectionUtils {

    private static boolean isNetworkConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        if (cm != null) {
            return cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().isConnected();
        } else {
            return false;
        }
    }

    private static boolean hasAccessToInternet() {
        final String command = "ping -c 1 google.com";
        try {
            boolean check = Runtime.getRuntime().exec(command).waitFor() == 0;
            return check;
        } catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean userHasConnection(Context context) {
        return isNetworkConnected(context) || hasAccessToInternet();
    }

}
