package co.pixelbeard.theanfieldwrap.utils;

import android.os.Handler;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import co.pixelbeard.theanfieldwrap.R;

/**
 * Created by Michael Stoddart
 * 14/02/2018.
 */

public class FragmentUtils {


    public static final String PODCASTS_TAG = "PODCASTS";
    public static final String VIDEOS_TAG = "VIDEOS";
    public static final String VIDEO_DETAILS_TAG = "VIDEO_DETAILS";
    public static final String WRITING_TAG = "WRITING";
    public static final String PROFILE_TAG = "PROFILE";
    public static final String PODCASTS_DETAILS_TAG = "PODCAST_DETAILS";
    public static final String WRITING_DETAILS_TAG = "WRITING_DETAILS";


    public static final String DOWNLOADS_TAG = "DOWNLOADS";
    public static final String ACCOUNT_DETAILS_TAG = "ACCOUNT_DETAILS";
    public static final String EDIT_EMAIL_TAG = "EDIT_EMAIL";
    public static final String EDIT_PASSWORD_TAG = "EDIT_PASSWORD";

    public static final String SETTINGS_TAG = "SETTINGS";
    public static final String HOW_TO_SUBSCRIBE_TAG = "HOW_TO_SUBSCRIBE";
    public static final String WALLET_TAG = "WALLET";
    public static final String AUDIO_PLAYER_TAG = "AUDIO_PLAYER";
    public static final String BUY_TOKENS_TAG = "BUY_TOKENS";

    public static final String YOUTUBE_PLAYER_TAG = "YOUTUBE_PLAYER_TAG";
    public static final String HOSTED_PLAYER_TAG = "HOSTED_PLAYER_TAG";

    public static void doReplaceFragmentTransaction(FragmentManager manager, int containerId, Fragment fragment, String TAG, boolean addToBackStack) {
        FragmentTransaction transaction = manager.beginTransaction();

        if (addToBackStack) {
            transaction.setCustomAnimations(R.anim.slide_in_from_right, R.anim.slide_out_left, R.anim.slide_in_from_left, R.anim.slide_out_right);
        }

        transaction.replace(containerId, fragment, TAG);
        if (addToBackStack) {
            transaction.addToBackStack(TAG);
        }

        new Handler().postDelayed(transaction::commitAllowingStateLoss, 100);
    }

    public static void doAddFragmentTransaction(FragmentManager manager, int containerId, Fragment fragment, String TAG, boolean addToBackStack) {
        FragmentTransaction transaction = manager.beginTransaction();

        if (addToBackStack) {
            transaction.setCustomAnimations(R.anim.slide_in_from_right, R.anim.slide_out_left, R.anim.slide_in_from_left, R.anim.slide_out_right);
        }

        transaction.add(containerId, fragment, TAG);
        if (addToBackStack) {
            transaction.addToBackStack(TAG);
        }

        new Handler().postDelayed(transaction::commitAllowingStateLoss, 100);
    }

    public static void doPlayerFragmentTransaction(FragmentManager manager, int containerId, Fragment fragment, String TAG, boolean addToBackStack) {
        FragmentTransaction transaction = manager.beginTransaction();
        transaction.setCustomAnimations(R.anim.translate_in_from_bottom, 0, 0, R.anim.translate_out_to_bottom);

        transaction.replace(containerId, fragment, TAG);
        if (addToBackStack) {
            transaction.addToBackStack(TAG);
        }


        new Handler().postDelayed(transaction::commitAllowingStateLoss, 100);
    }

    private static String getCurrentlyAttachedFragmentTag(FragmentManager mFragMan) {
        if (mFragMan.getBackStackEntryCount() == 0) {
            return null;
        }
        return mFragMan.getBackStackEntryAt(mFragMan.getBackStackEntryCount() - 1).getName();

    }

    public static BaseFragment getCurrentlyAttachedFragment(FragmentManager mFragMan) {
        String tag = getCurrentlyAttachedFragmentTag(mFragMan);

        if (tag != null) {
            return (BaseFragment) mFragMan.findFragmentByTag(tag);
        } else {
            return null;
        }
    }

    public static void clearBackStack(FragmentManager mFragMan) {
        for (int i = 0; i < mFragMan.getBackStackEntryCount(); ++i) {
            mFragMan.popBackStack();
        }
    }

    public static boolean shouldShowMiniPlayer(FragmentManager mFragMan) {
        String tag = getCurrentlyAttachedFragmentTag(mFragMan);

        if (tag != null) {
            if (tag.equals(PODCASTS_TAG) || tag.equals(PODCASTS_DETAILS_TAG) || tag.equals(PROFILE_TAG) ||
                    tag.equals(VIDEOS_TAG) || tag.equals(VIDEO_DETAILS_TAG) ||
                    tag.equals(WRITING_TAG) || tag.equals(WRITING_DETAILS_TAG)) {
                return true;
            } else {
                return false;
            }
        } else {
            return true;
        }

    }


}
