package co.pixelbeard.theanfieldwrap.utils;

import android.content.Context;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.widget.TextView;

public class TextUtils {


    public static void setTextPaddingColor(TextView textView, String text, Context context) {

        int padding = (int) ScreenUtils.dpToPx(10, context); // in pixels
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.M) {
            /**
             Causes strange crash with out this
             */
            textView.setShadowLayer(padding /* radius */, 0, 0, 0 /* transparent */);
        } else {
            textView.setShadowLayer(25 /* radius */, 0, 0, 0 /* transparent */);
        }

        textView.setPadding(padding, padding, padding, padding);

        Spannable spannable = new SpannableString(text);
        spannable.setSpan(new PaddingBackgroundColorSpan(
                context.getResources().getColor(android.R.color.black),
                padding
        ), 0, text.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        textView.setText(spannable);
    }

    public static String capitalise(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

}
