package co.pixelbeard.theanfieldwrap.walkthrough;

import android.content.Context;

/**
 * Created by Michael Stoddart
 * 17/12/2018.
 */
public class WalkthroughPresenter implements WalkthroughContract.Presenter {

    private WalkthroughContract.View mView;


    public WalkthroughPresenter(WalkthroughContract.View view) {

        if (view != null) {
            this.mView = view;


            mView.setPresenter(this);
        } else {
            throw new RuntimeException();
        }
    }


    @Override
    public void loginClicked() {
        mView.startLoginActivity();
    }

    @Override
    public void signUpClicked() {
        mView.startSignUpActivity();
    }

    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {

    }

    @Override
    public void clearUserData(Context context) {
        //Not needed
    }
}
