package co.pixelbeard.theanfieldwrap.walkthrough.fragments;


import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;

public class WalkthroughTwoFragment extends Fragment {

    @BindView(R.id.txt_walkthrough_text)
    TextView txtWalkthroughText;

    public WalkthroughTwoFragment() {
        // Required empty public constructor
    }

    public static WalkthroughTwoFragment newInstance() {
        WalkthroughTwoFragment fragment = new WalkthroughTwoFragment();
        Bundle args = new Bundle();

        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {

        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_walkthrough_two, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        txtWalkthroughText.setTypeface(FontUtils.getInstance().getDinAlternateBold());
    }

}
