package co.pixelbeard.theanfieldwrap.wallet;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.data.Transaction;
import co.pixelbeard.theanfieldwrap.podcasts.OnPodcastSelectedListener;
import co.pixelbeard.theanfieldwrap.videos.OnVideoSelectedListener;
import co.pixelbeard.theanfieldwrap.wallet.viewholders.BaseWalletViewHolder;
import co.pixelbeard.theanfieldwrap.wallet.viewholders.WalletCreditViewHolder;
import co.pixelbeard.theanfieldwrap.wallet.viewholders.WalletPodcastViewHolder;
import co.pixelbeard.theanfieldwrap.wallet.viewholders.WalletVideoViewHolder;

public class WalletAdapter extends RecyclerView.Adapter<BaseWalletViewHolder> {

    private static final int CREDIT = 1;
    private static final int PODCAST = 2;
    private static final int VIDEO = 3;


    private List<Transaction> mTransactions;
    private OnPodcastSelectedListener mPodcastSelectedListener;
    private OnVideoSelectedListener mVideoSelectedListener;

    public WalletAdapter(List<Transaction> transactions, OnPodcastSelectedListener podcastSelectedListener, OnVideoSelectedListener videoSelectedListener) {
        this.mTransactions = transactions;
        this.mPodcastSelectedListener = podcastSelectedListener;
        this.mVideoSelectedListener = videoSelectedListener;
    }

    @NonNull
    @Override
    public BaseWalletViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(parent.getContext());
        switch (viewType) {

            case CREDIT:
                Log.d("Wallet adapter", "CREDIT:");
                return new WalletCreditViewHolder(inflater.inflate(R.layout.viewholder_wallet_credit, parent, false));
            case PODCAST:
                Log.d("Wallet adapter", "PODCAST:");
                return new WalletPodcastViewHolder(inflater.inflate(R.layout.viewholder_wallet_podcast, parent, false), mPodcastSelectedListener);
            case VIDEO:
                Log.d("Wallet adapter", "VIDEO:");
                return new WalletVideoViewHolder(inflater.inflate(R.layout.viewholder_wallet_video, parent, false), mVideoSelectedListener);
            default:
                Log.d("Wallet adapter", "DEFAULT:");
                return new WalletCreditViewHolder(inflater.inflate(R.layout.viewholder_wallet_podcast, parent, false));
        }

    }

    @Override
    public void onBindViewHolder(@NonNull BaseWalletViewHolder holder, int position) {
        Transaction transaction = mTransactions.get(holder.getAdapterPosition());
        holder.bindView(transaction);
    }

    @Override
    public int getItemCount() {
        return mTransactions.size();
    }


    @Override
    public int getItemViewType(int position) {

        Transaction transaction = mTransactions.get(position);

        if (transaction.getTransactionType().equals("credit")) {
            return CREDIT;
        } else {
            if (transaction.getContentType() != null && transaction.getContentType().equals("podcast")) {
                return PODCAST;
            } else {
                return VIDEO;
            }
        }
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public void add(List<Transaction> transactions) {
        int oldSize = mTransactions.size();
        mTransactions.addAll(transactions);
        notifyItemRangeInserted(oldSize, transactions.size());
    }
}
