package co.pixelbeard.theanfieldwrap.wallet;

import android.content.Context;
import android.os.Handler;
import android.util.Log;

import co.pixelbeard.theanfieldwrap.data.responses.GenericResponse;
import co.pixelbeard.theanfieldwrap.data.responses.GetWalletResponse;
import co.pixelbeard.theanfieldwrap.data.source.DataRepository;
import co.pixelbeard.theanfieldwrap.networking.CallbackWrapper;
import co.pixelbeard.theanfieldwrap.utils.PrefKey;
import co.pixelbeard.theanfieldwrap.utils.PrefUtils;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class WalletPresenter implements WalletContract.Presenter {

    private static final String TAG = WalletPresenter.class.getSimpleName();


    private WalletContract.View mView;
    private DataRepository mRepo;

    public WalletPresenter(WalletContract.View view, DataRepository repo) {
        if (view != null && repo != null) {
            this.mView = view;
            this.mRepo = repo;

            mView.setPresenter(this);
        }
    }

    @Override
    public void getWallet(int pageNum) {
        if (mView != null && mView.checkConnection()) {
            if (pageNum == 1) {
                mView.showLoader("");
            } else {
                mView.setSwipeRefreshRefreshing(true);
                new Handler().postDelayed(() -> mView.showUi(), 50);
            }

            mRepo.getWallet().subscribe(new CallbackWrapper<GetWalletResponse>(mView) {
                @Override
                protected void onSuccess(GetWalletResponse walletResponse) {
                    if (mView != null) {
                        PrefUtils.getInstance().putIntPref(PrefKey.TOKEN_BALANCE, walletResponse.getWallet().getBalance());
                        mView.setWalletAdapter(walletResponse.getWallet());
                        new Handler().postDelayed(() -> {
                            if (mView != null) {

                                mView.showUi();
                            }
                        }, 50);
                    }
                }

                @Override
                protected void onSuccessFalse(GetWalletResponse getWalletResponse) {
                    if (mView != null) {
                        mView.showSingleButtonDialog("Error", getWalletResponse.getMessage());
                    }
                }
            });


        } else {
            if (mView != null) {
                mView.onConnectionError();
            }
        }
    }

    @Override
    public void refreshWallet() {

    }

    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {

    }

    @Override
    public void clearUserData(Context context) {
        //TODO test this
//        mRepo.clearAllData(context);
        mRepo.logout().subscribe(new Observer<GenericResponse>() {
            @Override
            public void onSubscribe(Disposable d) {

            }

            @Override
            public void onNext(GenericResponse genericResponse) {
                Log.d("LOGOUT", genericResponse.getMessage());
            }

            @Override
            public void onError(Throwable e) {

            }

            @Override
            public void onComplete() {

            }
        });

    }
}
