package co.pixelbeard.theanfieldwrap.utils;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.robolectric.RobolectricTestRunner;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * Created by Michael Stoddart
 * 10/10/2018.
 */

@RunWith(RobolectricTestRunner.class)
public class ValidationUtilsTest {


    @Test
    public void isValidEmail_Test() {

        String passEmail = "michael@pixelbeard.co";
        String emptyEmail = "";
        String invalidEmail1 = "michael.pixelbeard.co";
        String invalidEmail2 = "michael@pixelbeard";


        assertTrue(ValidationUtils.isValidEmail(passEmail));
        assertFalse(ValidationUtils.isValidEmail(emptyEmail));
        assertFalse(ValidationUtils.isValidEmail(invalidEmail1));
        assertFalse(ValidationUtils.isValidEmail(invalidEmail2));
    }


    @Test
    public void isValidPassword_Test() {
        String passPassword = "Password1";
        String emptyPassword = "";
        String invalidPass1 = "password1";
        String invalidPass2 = "Password";
        String invalidPass3 = "passw";


        assertTrue(ValidationUtils.isValidPassword(passPassword));
        assertFalse(ValidationUtils.isValidPassword(emptyPassword));
        assertFalse(ValidationUtils.isValidPassword(invalidPass1));
        assertFalse(ValidationUtils.isValidPassword(invalidPass2));
        assertFalse(ValidationUtils.isValidPassword(invalidPass3));
    }

    @Test
    public void isValidUsername_Test() {
        String passUsername = "anylengthuserNaMeiSaLL0w3d@@@";
        String emptyUserName = "";
        String nullUsername = null;

        assertTrue(ValidationUtils.isValidUsername(passUsername));
        assertFalse(ValidationUtils.isValidUsername(emptyUserName));
        assertFalse(ValidationUtils.isValidUsername(nullUsername));
    }

    @Test
    public void isValidActivationCode_Test() {
        String passCode = "J2C3V8";
        String emptyCode = "";
        String nullCode = null;

        assertTrue(ValidationUtils.isValidActivationCode(passCode));
        assertFalse(ValidationUtils.isValidActivationCode(emptyCode));
        assertFalse(ValidationUtils.isValidActivationCode(nullCode));
    }
}
