package co.pixelbeard.theanfieldwrap.buyTokens;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;

/**
 * Created by Michael Stoddart
 * 30/10/2018.
 */
public class IndicatorAdapter extends RecyclerView.Adapter<IndicatorAdapter.IndicatorViewHolder> {

    private int mCount = 0;
    private int resid = R.drawable.indicator_selected_bg;

    private int mSelectedPos = 0;

    public IndicatorAdapter(int count) {
        this.mCount = count;
    }
    public void setDotColor(int resid) {
        this.resid = resid;
    }

    @NonNull
    @Override
    public IndicatorViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_indicator, parent, false);
        return new IndicatorViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull IndicatorViewHolder holder, int position) {

        holder.indicator.setBackgroundResource(resid);


        if (holder.getAdapterPosition() == mSelectedPos) {
            holder.indicator.setAlpha(1);
            holder.indicator.setScaleY(1);
            holder.indicator.setScaleX(1);
        } else {
            holder.indicator.setAlpha(0.2f);
            holder.indicator.setScaleY(0.66f);
            holder.indicator.setScaleX(0.66f);
        }
    }

    public void setSelected(int pos) {
        if (mSelectedPos != pos) {
            notifyItemChanged(mSelectedPos);
            mSelectedPos = pos;
            notifyItemChanged(mSelectedPos);
        }
    }

    @Override
    public int getItemCount() {
        return mCount;
    }

    public class IndicatorViewHolder extends RecyclerView.ViewHolder {


        @BindView(R.id.indicator)
        View indicator;

        public IndicatorViewHolder(@NonNull View itemView) {
            super(itemView);

            ButterKnife.bind(this, itemView);
        }
    }
}
