package co.pixelbeard.theanfieldwrap.data;

import io.realm.RealmObject;
import io.realm.annotations.PrimaryKey;

public class RealmPodcast extends RealmObject {


    int cost, subLevel;
    @PrimaryKey
    Long postId;
    String title, content, createdDate, podcastFullUrl, thumbnail, mediumImage, largeImage, podcastLength, fileLocation;
    boolean premium;

    boolean purchased;

    public RealmPodcast() {
    }

    public RealmPodcast(Podcast podcast, String fileLocation) {
        this.premium = podcast.isPremium();
        this.postId = podcast.getPostId();
        this.title = podcast.getTitle();
        this.content = podcast.getContent();
        this.createdDate = podcast.getCreatedDate();
        this.podcastFullUrl = podcast.getPodcastFullUrl();
        this.thumbnail = podcast.getThumbnail();
        this.mediumImage = podcast.getMediumImage();
        this.largeImage = podcast.getLargeImage();
        this.podcastLength = podcast.getPodcastLength();
        this.fileLocation = fileLocation;
        this.cost = podcast.getCost();
        this.purchased = podcast.isPurchased();
        this.subLevel = podcast.getSubLevel();
    }

    public RealmPodcast(boolean premium, Long postId, String title, String content, String createdDate, String podcastFullUrl,
                        String thumbnail, String mediumImage, String largeImage, String podcastLength, String fileLocation, int cost, boolean purchased, int subLevel) {
        this.premium = premium;
        this.postId = postId;
        this.title = title;
        this.content = content;
        this.createdDate = createdDate;

        this.podcastFullUrl = podcastFullUrl;
        this.thumbnail = thumbnail;
        this.mediumImage = mediumImage;
        this.largeImage = largeImage;
        this.podcastLength = podcastLength;
        this.fileLocation = fileLocation;
        this.cost = cost;
        this.purchased = purchased;
        this.subLevel = subLevel;
    }

    public int getCost() {
        return cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public String getPodcastFullUrl() {
        return podcastFullUrl;
    }

    public void setPodcastFullUrl(String podcastFullUrl) {
        this.podcastFullUrl = podcastFullUrl;
    }

    public String getThumbnail() {
        return thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getMediumImage() {
        return mediumImage;
    }

    public void setMediumImage(String mediumImage) {
        this.mediumImage = mediumImage;
    }

    public String getLargeImage() {
        return largeImage;
    }

    public void setLargeImage(String largeImage) {
        this.largeImage = largeImage;
    }

    public String getPodcastLength() {
        return podcastLength;
    }

    public void setPodcastLength(String podcastLength) {
        this.podcastLength = podcastLength;
    }

    public String getFileLocation() {
        return fileLocation;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public boolean isPremium() {
        return premium;
    }

    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    public boolean isPurchased() {
        return purchased;
    }

    public void setPurchased(boolean purchased) {
        this.purchased = purchased;
    }

    public int getSubLevel() {
        return subLevel;
    }

    public void setSubLevel(int subLevel) {
        this.subLevel = subLevel;
    }
}
