package co.pixelbeard.theanfieldwrap.data.responses;

import com.google.gson.annotations.SerializedName;

import java.util.List;

import co.pixelbeard.theanfieldwrap.data.Video;
import co.pixelbeard.theanfieldwrap.networking.BaseResponse;

public class VideosResponse extends BaseResponse {

    @SerializedName("context")
    String context;
    @SerializedName("feed")
    List<Video> videos;

    public VideosResponse() {
    }

    public VideosResponse(boolean success, String message, String context, List<Video> videos) {
        super(success, message);
        this.context = context;
        this.videos = videos;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public List<Video> getVideos() {
        return videos;
    }

    public void setVideos(List<Video> videos) {
        this.videos = videos;
    }
}
