package co.pixelbeard.theanfieldwrap.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.dialog.twoButton.TwoButtonDialogListener;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.ScreenUtils;

public class DeviceLimitDialog extends Dialog {


    @BindView(R.id.txt_dialog_title)
    TextView txtDialogTitle;
    @BindView(R.id.txt_dialog_description)
    TextView txtDialogDescription;
    @BindView(R.id.btn_cancel)
    Button btnCancel;

    @BindView(R.id.btn_unlink)
    Button btnUnlink;

    private Context mContext;
    private TwoButtonDialogListener mListener;

    public DeviceLimitDialog(@NonNull Context context, TwoButtonDialogListener listener) {
        super(context);
        this.mContext = context;
        this.mListener = listener;
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        Window window = getWindow();

        if (window != null) {
            window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
            window.getAttributes().windowAnimations = R.style.TAWDialogAnimationStyle;
        }

        setContentView(R.layout.dialog_device_limit);
        ButterKnife.bind(this);

        WindowManager manager = (WindowManager) mContext.getSystemService(Activity.WINDOW_SERVICE);
        int width, height;

        Point point = new Point();
        manager.getDefaultDisplay().getSize(point);
        width = point.x;
        height = point.y;

        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(this.getWindow().getAttributes());
        lp.width = width;
        lp.height = (int) (height - ScreenUtils.dpToPx(30, mContext));
        this.getWindow().setAttributes(lp);

        this.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));


        setupTextViews();
        setupButtons();
    }


    private void setupTextViews() {
        txtDialogTitle.setTypeface(FontUtils.getInstance().getDinProBlack());
        txtDialogDescription.setTypeface(FontUtils.getInstance().getArialReg());
    }

    private void setupButtons() {
        btnUnlink.setTypeface(FontUtils.getInstance().getDinAlternateBold());
        btnCancel.setTypeface(FontUtils.getInstance().getDinAlternateBold());

        btnUnlink.setOnClickListener(v -> {
            dismiss();
            mListener.onYesClicked();
        });

        btnCancel.setOnClickListener(v -> {
            dismiss();
            mListener.onNoClicked();
        });
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

}
