package co.pixelbeard.theanfieldwrap.downloader;

import android.content.Context;
import android.content.ContextWrapper;

import androidx.annotation.NonNull;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.Status;

import java.io.File;

public class DownloadConstants {


    public static String getFilePath(@NonNull final String fileName, Context context) {

        ContextWrapper cw = new ContextWrapper(context);
        File dir = cw.getDir("tawDir", Context.MODE_PRIVATE);

        return dir.getAbsolutePath() + "/" + fileName + ".m4a";
    }

    public static boolean deleteFileFromExternalStorage(String filePath) {
        File file = new File(filePath);
        return file.delete();
    }

    public static void deleteDownloadsDirectory(Context context) {

        ContextWrapper cw = null;

        if (context == null) {
            return;
        }
        cw = new ContextWrapper(context);

        File dir = null;

        if (cw != null) {
            dir = cw.getDir("tawDir", Context.MODE_PRIVATE);
        }


        if (dir != null && dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                child.delete();
            }

        }
    }

    public static String handleFetchError(Error errorCode, Download download) {
        String error = "";

        switch (errorCode) {

            case UNKNOWN:
                error = "An unknown error occurred. Please try again.";
                break;
            case NO_STORAGE_SPACE:
                error = "No storage space available. Please free up some space and try again";
                break;
            case NONE:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case FILE_NOT_CREATED:
                error = "There was a problem (" + errorCode.getValue() + "). Please check your app permissions and try again.";
                break;
            case CONNECTION_TIMED_OUT:
                error = "Connection timed out. Please try again";
                break;
            case UNKNOWN_HOST:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case HTTP_NOT_FOUND:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case WRITE_PERMISSION_DENIED:
                error = "There was a problem (" + errorCode.getValue() + "). Please check your app permissions and try again.";
                break;
            case NO_NETWORK_CONNECTION:
                error = "No network connection available. Please connect to the internet and try again.";
                break;
            case EMPTY_RESPONSE_FROM_SERVER:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case REQUEST_ALREADY_EXIST:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case DOWNLOAD_NOT_FOUND:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case FETCH_DATABASE_ERROR:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case REQUEST_WITH_ID_ALREADY_EXIST:
                if (download.getStatus() == Status.FAILED) {
                    error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                }
                break;
            case REQUEST_WITH_FILE_PATH_ALREADY_EXIST:
                if (download.getStatus() == Status.FAILED) {
                    error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                }
                break;
            case REQUEST_NOT_SUCCESSFUL:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case UNKNOWN_IO_ERROR:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case FILE_NOT_FOUND:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case FETCH_FILE_SERVER_URL_INVALID:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case INVALID_CONTENT_HASH:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case FAILED_TO_UPDATE_REQUEST:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case FAILED_TO_ADD_COMPLETED_DOWNLOAD:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case FETCH_FILE_SERVER_INVALID_RESPONSE:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case REQUEST_DOES_NOT_EXIST:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case ENQUEUE_NOT_SUCCESSFUL:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case COMPLETED_NOT_ADDED_SUCCESSFULLY:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
            case ENQUEUED_REQUESTS_ARE_NOT_DISTINCT:
                error = "There was a problem (" + errorCode.getValue() + "). Please try again.";
                break;
        }


        return error;
    }


}
