package co.pixelbeard.theanfieldwrap.forgotPassword.fpAuth;

import android.content.Context;

import co.pixelbeard.theanfieldwrap.utils.ValidationUtils;

public class ForgotPasswordAuthPresenter implements ForgotPasswordAuthContract.Presenter {

    private ForgotPasswordAuthContract.View mView;

    public ForgotPasswordAuthPresenter(ForgotPasswordAuthContract.View view) {
        if (view != null) {
            this.mView = view;

            mView.setPresenter(this);
        }
    }


    @Override
    public boolean validateFields(String code, boolean shouldShowError) {
        boolean valid = true;

        if (!ValidationUtils.isValidActivationCode(code)) {
            valid = false;
            if (shouldShowError) {
                mView.showInvalidCodeError();
            }
        }

        if (valid) {
            mView.enableButton();
        } else {
            mView.disableButton();
        }

        return valid;
    }

    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {

    }

    @Override
    public void clearUserData(Context context) {
        //Not needed
    }
}
