package co.pixelbeard.theanfieldwrap.forgotPassword.fpNewPassword;

import android.content.Context;

import co.pixelbeard.theanfieldwrap.utils.ValidationUtils;

public class ForgotPasswordNewPasswordPresenter implements ForgotPasswordNewPasswordContract.Presenter {

    private ForgotPasswordNewPasswordContract.View mView;


    public ForgotPasswordNewPasswordPresenter(ForgotPasswordNewPasswordContract.View view) {
        if (view != null) {
            this.mView = view;

            mView.setPresenter(this);
        }
    }


    @Override
    public boolean validateFields(String password, String confirmPassword, boolean shouldShowError) {
        boolean valid = true;

        if (!ValidationUtils.isValidPassword(password)) {
            valid = false;

            if (shouldShowError) {
                mView.showInvalidPasswordError();
            }
        } else if (!password.equals(confirmPassword)) {
            valid = false;
            if (shouldShowError) {
                mView.showPasswordsDontMatchError();
            }
        }

        if (valid) {
            mView.enableButton();
        } else {
            mView.disableButton();
        }

        return valid;
    }

    @Override
    public void subscribe() {

    }

    @Override
    public void unsubscribe() {

    }

    @Override
    public void clearUserData(Context context) {
        //Not needed
    }
}
