package co.pixelbeard.theanfieldwrap.playerService;


import android.graphics.Bitmap;

import co.pixelbeard.theanfieldwrap.data.Podcast;
import co.pixelbeard.theanfieldwrap.data.source.DataSource;
import rx.Observer;

public interface MediaPlayerInterface {

    void queue(Podcast podcast, Bitmap albumArt);

    void play(Podcast podcast, Bitmap albumArt);

    void pause();

    void stop();

    void skipForward();

    void skipBackward();

    boolean isPlaying();

    boolean isQueued(Podcast podcast);

    long getDuration();

    long getElapsedTime();

    void seekTo(int progress);

    void subscribeToPlayerService(Observer<String> observer);

    void getPodcastState(long podcastId, int position, DataSource.PodcastStateCallback callback);

    boolean isServiceBound();
}
