package co.pixelbeard.theanfieldwrap.settings;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import co.pixelbeard.theanfieldwrap.R;
import co.pixelbeard.theanfieldwrap.data.NotificationSetting;
import co.pixelbeard.theanfieldwrap.utils.AnimUtils;
import co.pixelbeard.theanfieldwrap.utils.FontUtils;
import co.pixelbeard.theanfieldwrap.utils.ScreenUtils;

public class NotificationSettingsAdapter extends RecyclerView.Adapter<NotificationSettingsAdapter.NotificationSettingsViewHolder> {

    private List<NotificationSetting> mSettings;
    private NotificationSettingChangeListener mListener;

    private boolean isEnabled = true;

    public NotificationSettingsAdapter(List<NotificationSetting> settings, NotificationSettingChangeListener listener) {
        this.mSettings = settings;
        this.mListener = listener;
    }


    @NonNull
    @Override
    public NotificationSettingsViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new NotificationSettingsViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_notification_setting, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull NotificationSettingsViewHolder holder, int position) {

        NotificationSetting setting = mSettings.get(holder.getAdapterPosition());

        if (setting.getKey().equalsIgnoreCase("articles")) {
            holder.txtSettingName.setText("writing");
        } else {
            holder.txtSettingName.setText(setting.getKey());
        }

        if (setting.getValue() == 1) {
            switchOn(holder);
        } else {
            switchOff(holder);
        }

        holder.itemView.setOnClickListener(v -> {

            if (isEnabled) {
                if (setting.getValue() == 1) {
                    switchOff(holder);
                    setting.setValue(0);
                } else {
                    switchOn(holder);
                    setting.setValue(1);
                }
                mListener.onNotificationSettingChanged(setting);
            }
        });

    }

    private void switchOn(NotificationSettingsViewHolder holder) {
        int colorFrom = holder.itemView.getContext().getResources().getColor(R.color.redED1C24);
        int colorTo = holder.itemView.getContext().getResources().getColor(R.color.green_switch_on);

        AnimUtils.colorChangeAnim(colorFrom, colorTo, holder.switchState, 200);
        AnimUtils.horizontalTranslate(holder.switchState, 0);
    }

    private void switchOff(NotificationSettingsViewHolder holder) {
        int colorFrom = holder.itemView.getContext().getResources().getColor(R.color.green_switch_on);
        int colorTo = holder.itemView.getContext().getResources().getColor(R.color.redED1C24);

        AnimUtils.colorChangeAnim(colorFrom, colorTo, holder.switchState, 200);
        AnimUtils.horizontalTranslate(holder.switchState, ScreenUtils.dpToPx(40, holder.itemView.getContext()));
    }

    @Override
    public int getItemCount() {
        return mSettings.size();
    }

    public void enableSettings() {
        isEnabled = true;
    }

    public void disableSettings() {
        isEnabled = false;
    }

    public class NotificationSettingsViewHolder extends RecyclerView.ViewHolder {


        @BindView(R.id.txt_setting_name)
        TextView txtSettingName;
        @BindView(R.id.switch_state)
        View switchState;
        @BindView(R.id.txt_on)
        TextView txtOn;
        @BindView(R.id.txt_off)
        TextView txtOff;
        @BindView(R.id.ll_state_container)
        LinearLayout llStateContainer;


        public NotificationSettingsViewHolder(@NonNull View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);

            txtSettingName.setTypeface(FontUtils.getInstance().getDinAlternateBold());
            txtOff.setTypeface(FontUtils.getInstance().getRobotoBold());
            txtOn.setTypeface(FontUtils.getInstance().getRobotoBold());
        }
    }
}
